/* uikit publish script */

var googleMaps = new googleMaps();

function googleMaps(){
	this.directionsService = {};
	this.directionsDisplay = {};

	this.buildGoogleMaps = function(latCoordinates, longCoordinates, infoEdit, getType, getHeight, getId){
		var getDivMap = document.getElementById(getId);  

		function initialize() {
			googleMaps.directionsService[getId] = new google.maps.DirectionsService;
			googleMaps.directionsDisplay[getId] = new google.maps.DirectionsRenderer;
			var myLatlng = new google.maps.LatLng(latCoordinates,longCoordinates);
			var mapOptions = {
					zoom: 17,
					center: myLatlng,
					mapTypeId: getType
			};

			var map = new google.maps.Map(getDivMap, mapOptions);
			googleMaps.directionsDisplay[getId].setMap(map);

			var infowindow = new google.maps.InfoWindow({
				content: infoEdit
			});

			var marker = new google.maps.Marker({
				position: myLatlng,
				map: map,
				animation: google.maps.Animation.DROP,
				title: infoEdit
			});

			google.maps.event.addListener(marker, 'click', function() {
				infowindow.open(map,marker);
			});
			infowindow.open(map,marker);
		}

		google.maps.event.addDomListener(window, 'load', initialize());	 
		
		return true;
	}

	this.detectMobile = {
			Android: function() {
				return navigator.userAgent.match(/Android/i);
			},
			BlackBerry: function() {
				return navigator.userAgent.match(/BlackBerry/i);
			},
			iOS: function() {
				return navigator.userAgent.match(/iPhone|iPad|iPod/i);
			},
			Opera: function() {
				return navigator.userAgent.match(/Opera Mini/i);
			},
			Windows: function() {
				return navigator.userAgent.match(/IEMobile/i);
			},
			any: function() {
				return (googleMaps.detectMobile.Android() || googleMaps.detectMobile.BlackBerry() || googleMaps.detectMobile.iOS() || googleMaps.detectMobile.Opera() || googleMaps.detectMobile.Windows());
			}
	};

	this.calcRouteDesktop = function(elem){
		var getMapID = elem.attr('idmap');
		var getMapLat = elem.attr('latmap');
		var getMapLong = elem.attr('longmap');
		
		var Url = 'https://maps.googleapis.com/maps/api/geocode/json?address='+jQuery('.getAddress.'+getMapID).val()+'&key=AIzaSyAqKbegtgep8zb13Hstd_TkfgjXKiuxsMg';

		$.getJSON(Url, function(oBject){
			if(oBject.status == 'OK'){
	            var getCoordinates = oBject.results[0].geometry.location;

	            googleMaps.makeDirectionDesktop(getCoordinates.lat, getCoordinates.lng, getMapLat, getMapLong, getMapID);
			}else{
				alert('Your direction is not correct');
				return false;
			}
		});
		return true;
	}
	
	this.calcRouteMobile = function(elem){
		 var getMapID = elem.attr('idmap');
		 var getMapLat = elem.attr('latmap');
		 var getMapLong = elem.attr('longmap');
		
		 var endLat;
		 var endLng;
		 if(navigator.geolocation){
			 	 navigator.geolocation.getCurrentPosition(function(position) {
			 		endLat = position.coords.latitude;
			 		endLng = position.coords.longitude;
			 		googleMaps.makeDirectionMobile(endLat, endLng, getMapLat, getMapLong, getMapID);
				 });

		}else{
			alert('Browser doesn\'t support Geolocation');
			return false;
		}
		return true;
	}
	
	this.makeDirectionDesktop = function(endLat, endLong, startLat, startLong, getMapID){
		var start = new google.maps.LatLng(endLat,endLong);
		var end = new google.maps.LatLng(startLat,startLong);
		var request = {
				origin:start,
				destination:end,
				travelMode: google.maps.TravelMode.DRIVING
	  	};
		googleMaps.directionsService[getMapID].route(request, function(response, status) {
		  	if (status == google.maps.DirectionsStatus.OK) {
		  		googleMaps.directionsDisplay[getMapID].setDirections(response);
		  		console.log('google.maps.DirectionsStatus.OK');
			}
	  	});
		
		return true;
	}
	
	this.makeDirectionMobile = function(endLat, endLong, startLat, startLong, getMapID){
		var start = new google.maps.LatLng(endLat,endLng);
		var end = new google.maps.LatLng(startLat,startLong);
		var request = {
				origin:start,
				destination:end,
				travelMode: google.maps.TravelMode.DRIVING
	  	};
		googleMaps.directionsService[getMapID].route(request, function(response, status) {
		  	if (status == google.maps.DirectionsStatus.OK) {
		  		googleMaps.directionsDisplay[getMapID].setDirections(response);
			}
	  	});
	}
}

jQuery(document).ready(function(){

	//facebook
	jQuery('img.imgGoogleMaps').each(function(){
		//remove title 
		var getId = jQuery(this).attr('id');
		var getLat = jQuery(this).attr('latcoordinates');
		var getLong = jQuery(this).attr('longcoordinates');
		var getHeight = jQuery(this).attr('mapheight');
		var getType = jQuery(this).attr('view');
		var getInfo = jQuery(this).attr('inforwindow');

		jQuery(this).after('<div id="'+getId+'" style="height:'+getHeight+'px;"></div>')
		.after('<div id="panel" style="position:relative; z-index:1; top:45px; left: 0px; padding:5px 5px 0 5px; max-width:420px; margin:0 auto;background:#fff; opacity:0.85; cursor:default; ">'+
				'<button class="buttonDirectionMobile btn-google" style="background:#000; color:#fff; opacity:0.85; border:#7d7d7d solid 1px; cursor:pointer; margin-right:5px; margin-bottom:5px; padding:5px 15px;" idmap="'+getId+'" latmap="'+getLat+'" longmap="'+getLong+'">Get Direction</button>'+
				'<button class="buttonDirectionDesktop btn-google" style="background:#000; color:#fff; opacity:0.85; border:#7d7d7d solid 1px; cursor:pointer; margin-right:5px; margin-bottom:5px; padding:5px 15px;" idmap="'+getId+'" latmap="'+getLat+'" longmap="'+getLong+'">Get Direction</button>'+
		'from: <input type="text" class="getAddress '+getId+'" style="border:#7d7d7d solid 1px; opacity:0.85; cursor:default; padding:5px;"></div>');
		jQuery(this).remove();


		googleMaps.buildGoogleMaps(getLat, getLong, getInfo, getType, getHeight, getId);
	});
	
	jQuery('.buttonDirectionDesktop').click(function(){
		googleMaps.calcRouteDesktop($(this));
	});

	jQuery('.buttonDirectionMobile').click(function(){
		googleMaps.calcRouteMobile($(this));
	});
	
	//detect mobile or pc
	if(googleMaps.detectMobile.any()) {
		$(document).ready(function(){
			$('button.buttonDirectionDesktop,input.getAddress').hide();
		});
	}else{
		$(document).ready(function(){
			$('button.buttonDirectionMobile').hide();
		});
	}

});
